<?php

namespace App\Entity;

use App\Repository\SqrGeneratedKeyDomaineRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=SqrGeneratedKeyDomaineRepository::class)
 */
class SqrGeneratedKeyDomaine
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=SqrGeneratedKey::class, inversedBy="sqrGeneratedKeyDomaines")
     */
    private $sqrGeneratedKey;

    /**
     * @ORM\ManyToOne(targetEntity=Domaine::class, inversedBy="sqrGeneratedKeyDomaines")
     */
    private $domaine;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $generatedNumber;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $maxNumber;

    /**
     * @ORM\Column(type="datetime")
     */
    private $dateEnregistrement;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSqrGeneratedKey(): ?SqrGeneratedKey
    {
        return $this->sqrGeneratedKey;
    }

    public function setSqrGeneratedKey(?SqrGeneratedKey $sqrGeneratedKey): self
    {
        $this->sqrGeneratedKey = $sqrGeneratedKey;

        return $this;
    }

    public function getDomaine(): ?Domaine
    {
        return $this->domaine;
    }

    public function setDomaine(?Domaine $domaine): self
    {
        $this->domaine = $domaine;

        return $this;
    }

    public function getGeneratedNumber(): ?string
    {
        return $this->generatedNumber;
    }

    public function setGeneratedNumber(string $generatedNumber): self
    {
        $this->generatedNumber = $generatedNumber;

        return $this;
    }

    public function getMaxNumber(): ?string
    {
        return $this->maxNumber;
    }

    public function setMaxNumber(string $maxNumber): self
    {
        $this->maxNumber = $maxNumber;

        return $this;
    }

    public function getDateEnregistrement(): ?\DateTimeInterface
    {
        return $this->dateEnregistrement;
    }

    public function setDateEnregistrement(\DateTimeInterface $dateEnregistrement): self
    {
        $this->dateEnregistrement = $dateEnregistrement;

        return $this;
    }
}
